/**************************************************************************************
Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: cip_mr.h 77532 2018-08-29 10:10:49Z MarcBommert $:

Description:
  EtherNet/IP - CIP Message Router Object
**************************************************************************************/

#ifndef CIP_MR_H
#define CIP_MR_H

#include <stdint.h>
#include "cip_common.h"
#include "cip_object_dictionary_api.h"

#define CIP_MR_MAX_SERVICES         10    /* number of parallel CIP services        */

/************************************************************
*  Object specific defines
************************************************************
*/
#define CIP_MR_CLASS_NUMBER            0x02
#define CIP_MR_REVISION                1
#define CIP_MR_MAX_INSTANCE            1

#define CIP_MR_MAX_INSTANCE_ATTR       0

typedef void(*CIP_MR_SENDRESP_FUNC)(void * pvParam, CIP_OBJ_RESPONSE_T *tCIPResponse);

struct CIP_MR_RSC_Ttag; /* forward declaration */

void
CipMRHandleRequest(
  struct CIP_MR_RSC_Ttag* ptRsc,
  uint16_t                usLength,
  uint8_t*                pbData,
  CIP_MR_SENDRESP_FUNC    pfCallback,
  void*                   pvParam);

uint32_t
CipMR_ObjectCreate(struct EIP_RESOURCES_Ttag *hEip, void* pvParam);

  /*#####################################################################################*/


#endif /* CIP_MR_H */
